; F O G Y A S Z T  S   M  R 
;
; Lbkioszts:
;
;	Port   Funkci       Nv   llapot Irny
;	----------------------------------------
;	RA0:Kijelz tkapcs.  PWR    Pon.   ki
;	RA1:SDA               SDA    Neg.   ki
;	RA2:SCL               SCL    Neg.   ki
;	RA3:MRQ               MRQ    Neg.   ki
;	RA4:LED (ST,OC)      NLED    Neg.   ki

;	RB0:-                  -      -      -
;	RB1:SDA               SDA    Pon.   be
;	RB2:-                  -      -      -
;	RB3:Sebessg jelado   VSS    Pon.   be
;	RB4:Injektor szelep   INJ    Neg.   be
;	RB5:-                  -      -      -
;	RB6:-                  -      -      -
;	RB7:-                  -      -      -
;
;	Sebessg:	max 500Hz - min 10Hz (   2ms - 100ms), ( 180 -    4kmh)    [kmh]*2,77=[Hz]
;	Szelep:		max  60Hz - min  4Hz (16,6ms - 250ms), (7200 - 480rpm) [RPM]/120=[Hz]
;	Timer (seb):	4us (1:4) (4u - 125ms) A TMR0H legfelso bitjet nem szamolva
;	Timer (rpm):	8us (1:8) (8u - 250ms) A TMR0H legfelso bitjet nem szamolva
;	ra:		4MHz
;

	list p=16f84
	Title "fogy.asm"

	include <fogy.inc>


AREG	EQU	0ch		; Altalanos valtozo
BREG	EQU	0dh		; Altalanos valtozo
CREG	EQU	0eh		; Altalanos valtozo
TMR0H	EQU	0fh		; Timer 0 magas helyierteke
DREG	EQU	10h		; Altalanos valtozo
I2CBYTE	EQU	11h		; Az I2C-n elkuldendo adat
SEBH	EQU	12h		; A sebessg magas helyrtke
SEBL	EQU	13h		; A sebessg alacsony helyrtke
SEBK	EQU	14h		; A sebessg kitevje
SZLP1H	EQU	15h		; A szelep bekapcs. ideje magas h..
SZLP1L	EQU	16h		; A szelep bekapcs. ideje alacsony h..
SZLP1K	EQU	17h		; A szelep bekapcs. ideje kitevje
SZLPTH	EQU	18h		; A szelep teljes ideje magas h..
SZLPTL	EQU	19h		; A szelep teljes ideje alacsony h..
SZLPTK	EQU	1ah		; A szelep teljes ideje kitevje
KITH	EQU	1bh		; A kitoltesi ido felso
KITL	EQU	1ch		; A kitoltesi ido also
KITK	EQU	1dh		; A kitoltesi ido kitevoje
OSZT1	EQU	1eh		; Oszto
OSZT1K	EQU	1fh		; Oszto kitevo
OSZT2	EQU	20h		; Osztando
OSZT2K	EQU	21h		; Osztando kitevo
OSZTEL	EQU	22h		; Eredmeny also byte
OSZTEH	EQU	23h		; Eredmeny felso byte
OSZTEK	EQU	24h		; Eredmeny kitevo
SZOR1	EQU	25h		; Szorzo
SZOR1K	EQU	26h		; Szorzo kitevo
SZOR2	EQU	27h		; Szorzando
SZOR2K	EQU	28h		; Szorzando kitevo
SZOREL	EQU	29h		; Eredmeny also byte
SZOREH	EQU	2ah		; Eredmeny felso byte
SZOREHH	EQU	2bh		; Eredmeny legfelso byte
SZOREK	EQU	2ch		; Eredmeny kitevo
FOGYL	EQU	2dh		; Fogyasztas also byte
FOGYH	EQU	2eh		; Fogyasztas felso byte
FOGYK	EQU	2fh		; Fogyasztas kitevo
KIJ1	EQU	30h		; A kijelzett ertek 1 h.e.
KIJ0	EQU	31h		; A kijelzett ertek 0 h.e.
KIJT	EQU	32h		; A kijelzett ertek tort resze
VSZ	EQU	33h		; A vegtelen fogyasztasok szama (31 utan kioltom a kijelzot)
FOGYHE	EQU	34h		; Az elozo fogyasztas egesz resze
FOGYLE	EQU	35h		; Az elozo fogyasztas tort resze

; A kitevo azt jelenti, hogy hany 0-t kell meg hozzairni a szam vegehez
; (Ha negativ akkor felesleges 0-k vannak, ha pozitiv akkor kell meg)

; ========================== Vektorok ============================

	org	00h
	goto	start		; Foprogram

	org	3ffh
	goto	start		; Foprogram (Egy prg-ban lattam, hogy kell ilyen is)

; ========================== Timer IT ============================
; 1,024msec-knt@4MHz (4MHz-es ra=1MHz-es utasts ciklus)
;    vagy
; 2,038msec-knt@4MHz (4MHz-es ra=1MHz-es utasts ciklus)

	org	4h

	incf	TMR0H
	bcf	INTCON,T0IF
	retfie

; ****************************************************************
; ************************** Foprogram ***************************
; ****************************************************************

	org	08h
start
; =================== A periferiak inicializalasa ================

	bcf	STATUS,RP0		;Select Bank 0
	clrf	PORTA
	BSF	STATUS,RP0 		;Select Bank 1
	clrf 	TRISA 			;Set RA as outputs
	bsf	OPTION_REG,NOT_RBPU	;PORTB pull-ups disabled
	movlw	0x18
	movwf	TRISB			;Set RB as inputs

; ===================== TIMER0 setup ============================

	bsf	OPTION_REG,PS0
	bcf	OPTION_REG,PS1		;Prescaler=1:4
	bcf	OPTION_REG,PS2

	bcf	OPTION_REG,PSA		;Prescaler to TMR0
	bcf	OPTION_REG,T0CS		;TIMER0 from int. clk

	bcf	STATUS,RP0		;Select BANK0

	bcf	INTCON,T0IF		;TIMER0 IT flag clear
	bsf	INTCON,T0IE		;TIMER0 IT enable

	bsf	INTCON,GIE		;GLOBAL IT enable

; ========================= Fprogram ============================

foprg

	movlw	0x20		; Mar indulasnal alapbol
	movwf	VSZ		; ki van kapcsolva a kijelzo
	movlw	0x63		; 99
	movwf	FOGYHE
	movlw	0xff		; ,9
	movwf	FOGYLE

	clrf	PORTB		; PROBA!!!

; ==================== Wagon R+ kiiratasa ========================
; (Nem tudom a bekapcsolastol szamitva mikor irja ki eloszor,
; ezert biztos ami biztos kiiratom tobbszor: 10*(130+50)ms)

	bsf	PORTA,PWR	; Kijelzo atkapcs.
	call	wait01s

	movlw	0x0a
	movwf	DREG

wkiir	call	wagon		; Ciklus 10-szer
	call	wait01s

	decfsz	DREG
	goto	wkiir

; ==================== A sebessg mrrse ========================

seb	clrf	PORTB
	bsf	PORTB,0		; PROBA!!!

	bsf	STATUS,RP0 	;Select Bank 1
	bsf	OPTION_REG,PS0
	bcf	OPTION_REG,PS1	;Prescaler=1:4
	bcf	OPTION_REG,PS2
	bcf	STATUS,RP0	;Select BANK0

	clrf	TMR0		;
	clrf	TMR0H		;

	bcf	INTCON,T0IF	; clear TIMER0 IT flag
	bsf	INTCON,T0IE	; TIMER0 IT enable

seb0	btfsc	TMR0H,7		; Felfuto eltol felfuto elig
	goto	vgtln		; merek, ezert meg kell varni,
	btfsc	PORTB,VSS	; hogy 0 legyen az erteke
	goto	seb0		;

seb1	btfsc	TMR0H,7
	goto	vgtln
	btfss	PORTB,VSS
	goto	seb1		; Most van felfuto el

	clrf	TMR0
	clrf	TMR0H		; Innen indul a mrs

seb2	btfsc	TMR0H,7
	goto	vgtln
	btfsc	PORTB,VSS
	goto	seb2		; Lefuto el

seb3	btfsc	TMR0H,7
	goto	vgtln
	btfss	PORTB,VSS
	goto	seb3		; Masodik felfuto el

seb4	movf	TMR0,1	; *
	bcf	INTCON,T0IE	; TIMER0 IT disable

	movf	TMR0,1	; *
	movf	TMR0,0
	movwf	SEBL		; tmozgats a helyre
	movf	TMR0H,0
	movwf	SEBH

; ============= A sebessg lebeg pontosra hozsa ================

	bsf	PORTB,7		; PROBA!!!

; De elobb meg megnezem, hogy nem nulla-e veletlenul (vmi zaj)

	movf	SEBL,1
	btfss	STATUS,Z
	goto	sebleb0

	movf	SEBH,1
	btfsc	STATUS,Z
	goto	seb

sebleb0
	clrf	SEBK
sebleb	decf	SEBK,1

	movf	SEBK,0
	sublw	0xee
	btfsc	STATUS,C	; Ha 18 lepes utan sem talal 1-est
	goto	seb		; (Kitevo<-18) akkor baj van: uj meres

	bcf	STATUS,C
	rlf	SEBL,1		; Addig lptetem amig
	rlf	SEBH,1		; az els egyes ki nem lp
	btfss	STATUS,C
	goto	sebleb

; =================== A szelepido mrrse ========================

szlp
	clrf	PORTB
	bsf	PORTB,1		; PROBA!!!

	bsf	STATUS,RP0 	;Select Bank 1
	bcf	OPTION_REG,PS0
	bsf	OPTION_REG,PS1	;Prescaler=1:8
	bcf	OPTION_REG,PS2
	bcf	STATUS,RP0	;Select BANK0

	clrf	TMR0
	clrf	TMR0H

	bcf	INTCON,T0IF	; Clear TIMER0 IT flag
	bsf	INTCON,T0IE	; TIMER0 IT enable

szlp0	btfsc	TMR0H,7		; Lefutoeltol lefutoig merek,
	goto	nulla		; ezert meg kell varni, hogy
	btfss	PORTB,INJ	; 1 legyen
	goto	szlp0		;

szlp1	btfsc	TMR0H,7
	goto	nulla
	btfsc	PORTB,INJ	; Elso lefutoel
	goto	szlp1

	clrf	TMR0
	clrf	TMR0H		; Innen indul a mrs

szlp2	btfsc	TMR0H,7
	goto	nulla
	btfss	PORTB,INJ	; Felfutoel
	goto	szlp2

; Itt zart le a szelep: Nyitvatartasi ido elmentese

szlp3	movf	TMR0,1	; *
	movf	TMR0,0
	movf	TMR0,1	; *
	movwf	SZLP1L		; tmozgats a helyre
	movf	TMR0,1	; *
	movf	TMR0H,0
	movwf	SZLP1H

szlp4	btfsc	TMR0H,7
	goto	nulla
	btfsc	PORTB,INJ	; Masodik lefutoel
	goto	szlp4

szlp5	nop
	nop			; Idohuzas a fentebb megallitott TMR0 miatt
	nop
	nop
	movf	TMR0,1	; *
	bcf	INTCON,T0IE	;TIMER0 IT disable

	movf	TMR0,1	; *
	movf	TMR0,0
	movwf	SZLPTL		; tmozgats a helyre
	movf	TMR0H,0
	movwf	SZLPTH

; ============= A szelepid lebeg pontosra hozsa ===============

	bsf	PORTB,7		; PROBA!!!

; De elobb meg megnezem, hogy nem nulla-e veletlenul (vmi zaj)

	movf	SZLP1L,1
	btfss	STATUS,Z
	goto	nullae1

	movf	SZLP1H,1
	btfsc	STATUS,Z
	goto	szlp

nullae1	movf	SZLPTL,1
	btfss	STATUS,Z
	goto	szlplb

	movf	SZLPTH,1
	btfsc	STATUS,Z
	goto	szlp

szlplb
	clrf	SZLP1K
szlp0lb	decf	SZLP1K,1

	movf	SZLP1K,0
	sublw	0xee
	btfsc	STATUS,C	; Ha 18 lepes utan sem talal 1-est
	goto	szlp		; (Kitevo<-18) akkor gaz van: ujra

	bcf	STATUS,C
	rlf	SZLP1L,1	; Addig lptetem amig
	rlf	SZLP1H,1	; az els egyes ki nem lp

	btfss	STATUS,C
	goto	szlp0lb

	clrf	SZLPTK
szlptlb	decf	SZLPTK,1

	movf	SZLPTK,0
	sublw	0xee
	btfsc	STATUS,C	; Ha 18 lepes utan sem talal 1-est
	goto	szlp		; (Kitevo<-18) akkor gaz van: ujra

	bcf	STATUS,C
	rlf	SZLPTL,1	; Addig lptetem amig
	rlf	SZLPTH,1	; az els egyes ki nem lp

	btfss	STATUS,C
	goto	szlptlb

; ======================= Kitoltesi tenyezo =====================

kit	clrf	PORTB
	bsf	PORTB,2		; PROBA!!!

	movf	SZLP1H,0
	movwf	OSZT2
	movf	SZLP1K,0
	movwf	OSZT2K

	movf	SZLPTH,0
	movwf	OSZT1
	movf	SZLPTK,0
	movwf	OSZT1K

	call	osztas

	movf	OSZTEH,0
	movwf	KITH
	movf	OSZTEL,0
	movwf	KITL
	movf	OSZTEK,0
	movwf	KITK

; ======================= Fogyasztas szamolasa ==================

fogy	clrf	PORTB
	bsf	PORTB,5		; PROBA!!!

	movf	KITH,0
	movwf	SZOR1
	movf	KITK,0
	movwf	SZOR1K

	movf	SEBH,0
	movwf	SZOR2
	movf	SEBK,0
	movwf	SZOR2K

	call	szorzas

	movf	SZOREH,0
	movwf	FOGYH
	movf	SZOREL,0
	movwf	FOGYL
	movf	SZOREK,0
	movwf	FOGYK

; ======================= Fogyasztas skalazasa ==================
;
skala	clrf	PORTB
	bsf	PORTB,6		; PROBA!!!

	movf	FOGYH,0
	movwf	SZOR1
	movf	FOGYK,0
	movwf	SZOR1K

	movlw	0x58
	movwf	SZOR2		;(1) 0101 1000 * 2^-5
	movlw	0xfb
	movwf	SZOR2K

	call	szorzas

	movf	SZOREH,0
	movwf	FOGYH
	movf	SZOREL,0
	movwf	FOGYL
	movf	SZOREK,0
	movwf	FOGYK

; =================== Fogyasztas leb p.=> fix p.=================
; FOGYH egeszresz
; FOGYL tortresz

	movf	FOGYK,0
	sublw	0x80		; A kitevo + v. -
	btfsc	STATUS,C
	goto	vgtln		; Ha pozitiv akkor a fogy. vegtelen (max: 99.9)

	movf	FOGYK,0
	sublw	0xf2		; A kitevo kissebb-e mint -13
	btfsc	STATUS,C
	goto	nulla		; Ha kisebb akkor a fogy. nulla (min: 0.0)

	clrf	AREG
	bsf	STATUS,C
	goto	fix0
fix1	bcf	STATUS,C
fix0	rrf	FOGYH,1
	rrf	FOGYL,1
	rrf	AREG
	incfsz	FOGYK,1
	goto	fix1

	movf	FOGYH,0
	sublw	0x63
	btfss	STATUS,C	; nagyobb-e mint 99?
	goto	vgtln

; atlagolas
	movf	FOGYL,0		; Osszeadogatom a mostani
	addwf	FOGYLE,1	; es az elozo eredmenyt
	btfsc	STATUS,C	; (atvitelle az egeszeknel nem
	incf	FOGYHE,1	; kell foglalkozni, mert a max
	movf	FOGYH,0		; ertekuk 99. (99d+99d=c6h)
	addwf	FOGYHE,1	; (Az eredmeny az Elozo-ben marad)

	bcf	STATUS,C
	rrf	FOGYHE,1	; Osztom kettovel
	rrf	FOGYLE,1

	movf	FOGYHE,0
	movwf	FOGYH		; Az eredmenyt kiiratom
	movf	FOGYLE,0
	movwf	FOGYL

	clrf	VSZ		; Ha kisebb akkor ez nem vegtelen
	call	konv		; hexa-dec konvertalas

	goto	kiir

; ====================== vegtelen fogyasztas ====================

vgtln
	movlw	0xfd		; A kiiratasnal hozzaadok 30-at
	movwf	KIJT		; igy lesz belole 2d="-".
	movwf	KIJ1
	movwf	KIJ0

	movlw	0x63
	movwf	FOGYHE		; Az elozo erteknek is vegtelennek kell lennie
	movlw	0xf0
	movwf	FOGYLE

	btfss	VSZ,5		; Ha a VSZ meg kisebb mint 32
	incf	VSZ,1		; akkor meginkrementalom

	goto	kiir

; ======================== nulla fogyasztas =====================

nulla
	clrf	KIJT
	clrf	KIJ0
	clrf	KIJ1

	clrf	FOGYHE		; Az elozoeket is ki kell torolni
	clrf	FOGYLE		;

	clrf	VSZ

	goto	kiir

; =========================== kiiratas ==========================

kiir
; kijelzo ki/bekapcsolasa

	btfss	VSZ,5		; Ha VSZ=32, kikapcs es vissza elore
	goto	kiir3
	bcf	PORTA,PWR
	goto	seb

kiir3
	btfsc	PORTA,PWR	; Ha VSZ<32 es a kijelzo mar be van kapcsolva
	goto	kiir2		; akkor indulhat a kiiras

	bsf	PORTA,PWR	; Ha nincs bekapcsolva akkor bekapcs

	bsf	STATUS,RP0 	; Select Bank 1
	bsf	OPTION_REG,PS0
	bcf	OPTION_REG,PS1	; Prescaler=1:4 (Az idozitesek miatt)
	bcf	OPTION_REG,PS2
	bcf	STATUS,RP0	; Select BANK0

	call	wait1ms		; es 1ms varakozas (bar ez nagyon keves)

kiir2
	bcf	PORTA,NLED

	bsf	STATUS,RP0 	; Select Bank 1
	bsf	OPTION_REG,PS0
	bcf	OPTION_REG,PS1	; Prescaler=1:4 (Az idozitesek miatt)
	bcf	OPTION_REG,PS2
	bcf	STATUS,RP0	; Select BANK0

	bcf	PORTA,MRQ
	bcf	PORTA,SDA	; Biztos, ami biztos,
	bcf	PORTA,SCL	; mindent magasba

; Kommunikacio kezdete

	bsf	PORTA,MRQ	; A komm. kezdete:
	call	wait1ms		; MRQ neg. impulzus
	bcf	PORTA,MRQ	;

	call	wait1ms

; Start jel

	bsf	PORTA,SDA	; START:
	call	wait1ms		; SCL=1, SDA=lefutoel
	bsf	PORTA,SCL	; Legvegul a Clock-ot is kitorlom

; Byte-ok kuldese

	movlw	0x4a		; A kijelzo cime
	call	sendI2C

	bsf PORTA,MRQ		; A cim elkuldese utan 0-ba kell vinni az MRQ-t

	movlw	0x40		; Az osszes lampa kozul egyedul
	call	sendI2C		; a tizedes pontot gyujtom ki
	movlw	0x00		; (Csak ezt a pontot tudom)
	call	sendI2C

	movlw	0x4c
	call	sendI2C 	; "L"

	movlw	0x2f
	call	sendI2C		; "/"

	movlw	0x4b
	call	sendI2C 	; "K"

	movlw	0x4d
	call	sendI2C		; "M"

	movlw	0x20
	call	sendI2C		; "Space"

	movf	KIJ1,0
	btfss	STATUS,Z	; Ha a legelso karakter 0, akkor helyette "Space"-t kuldok (20h)
	goto	kiir0
	movlw	0x20		; "Space"
	goto	kiir1
kiir0	addlw	0x30		; ASCII=szam+30h
	bcf	STATUS,C
kiir1	call	sendI2C

	movf	KIJ0,0
	addlw	0x30
	call	sendI2C 	; A masodik szam kuldese

	movf	KIJT,0
	addlw	0x30
	call	sendI2C 	; A harmadik szam kuldese (Tortresz)

	call	wait1ms
	bcf	PORTA,MRQ	; A kuldes vegen az MRQ-t 1-be kell rakni

	bsf	PORTA,SDA
	call	wait1ms
	bcf	PORTA,SCL	; Stop:
	call	wait1ms
	bcf	PORTA,SDA	; SCL=1, SDA=felfutoel
	call	wait1ms

	bcf	PORTA,MRQ
	bcf	PORTA,SDA	; Vege, mindent magasba
	bcf	PORTA,SCL

	bsf	PORTA,NLED

; ========================== A vge ==============================

	goto	seb

; ****************************************************************
; ************************** Rutinok *****************************
; ****************************************************************

; ====================== Hex-Dec konv ============================
; A FOGYL-ben van a fogyasztas tort resze
; A FOGYH-ban van a fogyasztas egesz resze


konv	clrf	KIJ0
	clrf	KIJ1
	clrf	KIJT

	movf	FOGYH,0
	andlw	0x0f
	sublw	0x09		; Az also 4 bit
	btfss	STATUS,C	; nagyobb-e mint 9?
	goto	nagy9
kis9	movf	FOGYH,0
	andlw	0x0f
	movwf	KIJ0
	goto	konv0		; Ha kisebb akkor vege
nagy9	movlw	0x01
	movwf	KIJ1		; Ha nagyobb akkor a KIJ1-be 1,
	movf	FOGYH,0		; a KIJ0-ba pedig [Hex]-6
	addlw	0x06
	andlw	0x0f
	movwf	KIJ0

konv0	swapf	FOGYH,0		; A felso 4 bit vizsgalata
	andlw	0x0f
	movwf	CREG
	btfsc	STATUS,Z	; Ha 0 a msodik szmjegy
	goto	tort

dek1	incf	KIJ1,1		; Minden krben nvelni kell
	movf	KIJ0,0
	addlw	0x16		; FOGYE*(+16)
	andlw	0x0f
	movwf	KIJ0
	sublw	0x09
	btfss	STATUS,C	; Nagyobb-e mint 9?
	goto	nagy9_
kis9_	movf	KIJ0,0
	andlw	0x0f
	movwf	KIJ0
	goto	dek2
nagy9_	incf	KIJ1,1
	movf	KIJ0,0
	addlw	0x06
	andlw	0x0f
	movwf	KIJ0
dek2	decfsz	CREG,1
	goto	dek1

tort	movlw	0x0a		; A tort resz vizsgalata
	movwf	CREG		; Ha megszorzom 10d-zel (Ah)
	swapf	FOGYL,0		; Akkor megkapom a tortreszt dec-ben
	andlw	0x0f
	clrf	KIJT

tort0	addwf	KIJT,1		; 10*tort

	decfsz	CREG,1
	goto	tort0

	swapf	KIJT,0
	andlw	0x0f
	movwf	KIJT

	clrf	VSZ		; Nem vegtelen a fogyasztas

	return

; ========================= Osztas ===============================
;
; Az osztot addig adogatom ossze mig az atvitelek osszge
; (vagyis a kov. helyiertek) el nem eri az osztandot

osztas
	clrf	OSZTEL
	clrf	OSZTEH
	decf	OSZTEL,1	; Mert egyet csal
	decf	OSZTEH,1	;

	clrf	BREG		; BREG-ben az ideiglenes osszeg felso byte-ja
	clrf	CREG		; CREG-ben az ideiglenes osszeg legelso bitje
	clrf	AREG		; AREG-ben az ideiglenes osszeg also byte-ja

oszt0	incf	OSZTEL,1	; Minden korben inkrementalom az eredmenyt
	movf	OSZTEL,1	;
	btfsc	STATUS,Z	; Ha az also byte tulcsordul akkor inc a felso
	incf	OSZTEH,1

	movf	OSZT1,0

	addwf	AREG,1		; Eredmny vissza az AREG-be
	btfss	STATUS,C	; SKIP ha AREG tulcsordult
	goto	oszt2

	incf	BREG,1		; BREG inkrementalasa
	btfsc	STATUS,Z	; Ha BREG tulcsordul akkor inkrementalom a CREG-et
	incf	CREG,1

oszt2	incf	BREG,1		; BREG inkrementalasa a levagott egyes miatt
	btfsc	STATUS,Z	; Ha BREG tulcsordul akkor inkrementalom a CREG-et
	incf	CREG,1

	btfsc	CREG,1		; Akkor is vege van, ha a CREG elerte a 2-t
	goto	oszt1		; (Csak akkor kell, ha az osztando 1FFh)

	movf	BREG,0		; akkor van vege, ha BREG nagyobb mint az oszto
	subwf	OSZT2,0		; es a CREG is 1
	btfsc	STATUS,C
	goto	oszt0		; Ha meg kisebb akkor vissza
	movf	CREG,1		; CREG mozgatsa sajt magba
	btfsc	STATUS,Z	; Ha mr nem nulla akkor vge
	goto	oszt0

oszt1	movf	OSZT1K,0	; A kitevo szamolasa
	subwf	OSZT2K,0	; OSZTEK=OSZT2K-OSZT1K+8-8
;	addlw	0x08		; -8 az elejen levo 256 szorzas miatt
	movwf	OSZTEK		; +8 a 2 byte-on valo abrazolas miatt

; Az eredmeny lebego pontosra hozasa
; (de elobb megnezem nem-e nulla)

	bsf	PORTB,7		; PROBA!!!

	movf	OSZTEL,1
	btfss	STATUS,Z
	goto	oszt3

	movf	OSZTEH,1
	btfsc	STATUS,Z
	goto	oszt4		; Ha nulla az eredmeny

oszt3	decf	OSZTEK,1
	bcf	STATUS,C
	rlf	OSZTEL,1	; Addig lptetem amig
	rlf	OSZTEH,1	; az els egyes ki nem lp

	btfss	STATUS,C
	goto	oszt3

	return

oszt4	movlw	0xb0
	movwf	OSZTEK		; Nulla az eredmeny
	clrf	OSZTEH		; (A szorzoba nagyon minuszt irok)
	clrf	OSZTEL

	return

; ======================== Szorzas ===============================

szorzas
; Ha valamelyik szam 0 akkor az eredmeny is

	clrf	SZOREL		; Legkisebb h.e.
	clrf	SZOREH		; Kozepso
	clrf	SZOREHH		; Legnagyobb
	movlw	2		; BREG-ben a szorzo elso egyes-e
	movwf	BREG		; BREG=2
	movf	SZOR2,0
	movwf	CREG		; CREG a szorzo

szor0	movf	SZOR1,0		; SZOR1-et SZOR2-szor hozzadaogatom
	addwf	SZOREL,1	; SZOREL-hez.
	btfss	STATUS,C
	goto	szor4

	incf	SZOREH,1	; Ha tulcsordul az also byte
	btfsc	STATUS,Z	; Ha mr nem nulla akkor vge
	incf	SZOREHH,1

szor4	incf	SZOREH,1	; Az elso 1-es miatt
	btfsc	STATUS,Z	; Ha mr nem nulla akkor vge
	incf	SZOREHH,1

	decfsz	CREG,1		; Ha DREG meg nem nulla akkor megegyszer
	goto	szor0
	decfsz	BREG,1
	goto	szor0

szor1	movf	SZOR1K,0	; A kitevo szamolasa
	addwf	SZOR2K,0	; KITK=SZLP1K+SZLPTK+8
	addlw	0x08		;
	movwf	SZOREK		; a +8 a "*" resz miatt kell

; Az eredmeny lebego pontosra hozasa
; (de elobb megnezem nem-e nulla)

	movf	SZOREL,1
	btfss	STATUS,Z
	goto	szor3

	movf	SZOREH,1
	btfss	STATUS,Z
	goto	szor3

	movf	SZOREHH,1
	btfsc	STATUS,Z
	goto	szor5		; Ha nulla az eredmeny

szor3	decf	SZOREK,1
	bcf	STATUS,C
	rlf	SZOREL,1	; Addig lptetem amig
	rlf	SZOREH,1	; az els egyes ki nem lp
	rlf	SZOREHH,1

	btfss	STATUS,C
	goto	szor3

	movf	SZOREH,0
	movwf	SZOREL		; A SZOREHH nem hasznlom ezert
	movf	SZOREHH,0	; SZOREHH>SZOREH>SZOREL
	movwf	SZOREH		; "*"

	movf	SZOREK,0
	addlw	0x08		; Es a kitevohoz is hozza kell adni 8-at
	movwf	SZOREK

	return

szor5	clrf	SZOREL
	clrf	SZOREH
	movlw	0xb0		; Ha nulla az eredmeny
	movwf	SZOREK		; (A szorzoba egy nagyon minuszt irok)

	return

; ===================== 1msec-es idozites ========================
; 1ms~=TMR0 7.bitje mikor egybe vlt (128*8*1us+6us)

wait1ms
	clrf	TMR0
	clrf	TMR0H
wait1	btfss	TMR0,7
	goto	wait1

	return

; =================== 0,25msec-es idozites ========================
; 0,25ms~=TMR0 5.bitje mikor egybe vlt (32*8*1us+6us)

wait025ms
	clrf	TMR0
	clrf	TMR0H
wait025	btfss	TMR0,5
	goto	wait025

	return

; ==================== 0,1sec-es idozites ========================
; A TMR0H legfelso bitje

wait01s
	clrf	TMR0
	clrf	TMR0H
wait01	btfss	TMR0H,7
	goto	wait01

	return

; ================== 1byte elkuldese I2C-n =======================
; A W-ben erkezo adatot kuldi el

; A paritas kiszamolasa

sendI2C
	movwf	BREG		; Az elkuldendo byte (W-ben van benne)
	movwf	I2CBYTE		; Az elkuldendo byte (W-ben van benne)
	clrf	CREG		; Az 1-ek szama
	movlw	0x07
	movwf	AREG		; Ciklus valtozo

send0	rrf	BREG		; Korbe forgatom a byte-t,
	btfsc	STATUS,C	; es osszeszamolom az 1-ket
	incf	CREG		; (Kiveve a legnagyobb bitet)
	decfsz	AREG,1
	goto	send0

	rlf	I2CBYTE,1	; Egyet elleptetem, hogy a paritas moge ferjen
	bcf	I2CBYTE,0
	btfss	CREG,0		; Ha CREG paratlan, akkor a paritast
	bsf	I2CBYTE,0	; torolni kell

; A byte elkuldese

	movlw	8		;
	movwf	CREG		; Ciklus 8x

send1
	bsf	PORTA,SCL	; Clock=0 (Biztos ami biztos)
	call	wait025ms

	btfsc	I2CBYTE,7	; A byte 7. bitje 0/1
	goto	send3
	bsf	PORTA,SDA	; 0
	goto	send4
send3
	bcf	PORTA,SDA	; 1
send4
	call	wait025ms
	bcf	PORTA,SCL	; Clock=1 Ervenyes adat a kimeneten
	call	wait025ms

	rlf	I2CBYTE,1	; Leptetem egyel a byte-ot

	decfsz	CREG,1		; Ciklusvaltozo
	goto	send1

	bsf	PORTA,SCL
	call	wait025ms

; Nyugta a slave-tol

	bcf	PORTA,SDA	; Igy tud csak nyugtat kuldeni
	call	wait025ms
	bcf	PORTA,SCL	; Clock=1 johet a nyugta
	call	wait025ms

	bcf	STATUS,C
	btfss	PORTB,SDA	; Nyugta OK?
	bsf	STATUS,C	; Ha OK, set carry (NACK)

	bsf	PORTA,SCL	; Clock=0
	call	wait025ms
	bsf	PORTA,SDA	; Adat=0

	return

; ==================== Wagon R+ kiiratasa ========================

wagon
	bcf	PORTA,NLED

	bcf	PORTA,MRQ
	bcf	PORTA,SDA	; Biztos, ami biztos,
	bcf	PORTA,SCL	; mindent magasba

; Kommunikacio kezdete

	bsf	PORTA,MRQ	; A komm. kezdete:
	call	wait1ms		; MRQ neg. impulzus
	bcf	PORTA,MRQ	;

	call	wait1ms

; Start jel

	bsf	PORTA,SDA	; START:
	call	wait1ms		; SCL=1, SDA=lefutoel
	bsf	PORTA,SCL	; Legvegul a Clock-ot is kitorlom

; Byte-ok kuldese

	movlw	0x4a		; A kijelzo cime
	call	sendI2C

	bsf PORTA,MRQ		; A cim elkuldese utan 0-ba kell vinni az MRQ-t

	clrw
	call	sendI2C		; Osszes lampa kikapcs
	clrw
	call	sendI2C

	movlw	0x57
	call	sendI2C		; "W"

	movlw	0x41
	call	sendI2C 	; "A"

	movlw	0x47
	call	sendI2C		; "G"

	movlw	0x4f
	call	sendI2C		; "O"

	movlw	0x4e
	call	sendI2C		; "N"

	movlw	0x20
	call	sendI2C 	; "Space"

	movlw	0x52
	call	sendI2C 	; "R"

	movlw	0x2b
	call	sendI2C		; "+"

	call	wait1ms
	bcf	PORTA,MRQ	; A kuldes vegen az MRQ-t 1-be kell rakni

	bsf	PORTA,SDA
	call	wait1ms
	bcf	PORTA,SCL	; Stop:
	call	wait1ms
	bcf	PORTA,SDA	; SCL=1, SDA=felfutoel
	call	wait1ms

	bcf	PORTA,MRQ
	bcf	PORTA,SDA	; Vege, mindent magasba
	bcf	PORTA,SCL

	bsf	PORTA,NLED

	return

end

